/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.store;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.store.AbstractStoreSchedule;
import cz.insophy.inplan.store.StoreActivity;
import cz.insophy.inplan.util.list.SortedLists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class DefaultStoreSchedule
extends AbstractStoreSchedule {
    public DefaultStoreSchedule(Collection<? extends Material> materials) {
        super(materials);
        this.activities = new HashMap();
        SaComparator saComparator = new SaComparator();
        for (Material material : materials) {
            this.activities.put(material, SortedLists.create(saComparator));
        }
    }

    @Override
    public void addActivity(StoreActivity activity) {
        this.addActivity(activity, true);
    }

    @Override
    public void addActivities(Collection<? extends StoreActivity> activities) {
        ArrayList<Material> matList = Lists.newArrayList();
        for (StoreActivity storeActivity : activities) {
            matList.add(storeActivity.getMaterial());
            this.addActivity(storeActivity, false);
        }
        for (Material material : matList) {
            this.bumpVersion(material);
        }
    }

    private void addActivity(StoreActivity activity, boolean bumpVersion) {
        List<StoreActivity> matList = this.getMatActList(activity);
        matList.add(activity);
        if (bumpVersion) {
            this.bumpVersion(activity.getMaterial());
        }
    }

    @Override
    public boolean removeActivity(StoreActivity activity) {
        return this.removeActivity(activity, true);
    }

    @Override
    public void removeActivities(Collection<? extends StoreActivity> activities) {
        ArrayList<Material> materials = Lists.newArrayList();
        for (StoreActivity storeActivity : activities) {
            this.removeActivity(storeActivity, false);
            materials.add(storeActivity.getMaterial());
        }
        for (Material material : materials) {
            this.bumpVersion(material);
        }
    }

    private boolean removeActivity(StoreActivity activity, boolean bumpVersion) {
        List<StoreActivity> matList = this.getMatActList(activity);
        if (bumpVersion) {
            this.bumpVersion(activity.getMaterial());
        }
        return matList.remove(activity);
    }

    @Override
    public void removeAllActivities() {
        for (List activityList : this.activities.values()) {
            activityList.clear();
        }
        this.bumpAllVersions();
    }

    @Override
    public DefaultStoreSchedule copyStoreStructure() {
        HashMap actsCopy = Maps.newHashMap(this.activities);
        DefaultStoreSchedule copy = new DefaultStoreSchedule(actsCopy.keySet());
        for (List saList : actsCopy.values()) {
            copy.addActivities(saList);
        }
        return copy;
    }

    private static class SaComparator
    implements Comparator<StoreActivity> {
        private SaComparator() {
        }

        @Override
        public int compare(StoreActivity o1, StoreActivity o2) {
            return o1.getStart() < o2.getStart() ? -1 : (o1.getStart() == o2.getStart() ? 0 : 1);
        }
    }
}

